#
# Tello Python3 Control Demo 
#
# 2018-12-19

import socket
import sys
from time import sleep

tello_ip = ('192.168.10.1', 8889)

host = ''
port = 9001
locaddr = (host,port) 


# Create a UDP socket
sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)

tello_address = ('192.168.10.1', 8889)

sock.bind(locaddr)

print ('\r\n\r\nTello Python3 Demo.\r\n')

# コマンドスタート
sent = sock.sendto(b'command', tello_address)
print ("command")

# コマンド実行関数
def drone(command):

	byte_command= bytes(command, encoding="utf-8")
	sent = sock.sendto(byte_command, tello_address)
	print (byte_command)

	# Telloの命令実行後の待ち時間(takeoff後は長めでないと反応が悪い)
	if command == 'takeoff':
		sleep(10)
	else:
		sleep(5)

